---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：147-CRI API定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **ImageService RPCの完全な一覧**：根拠不足（api.protoの後半部分未読取）

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto` -- CRI protobuf定義（先頭100行）
- E-02: `staging/src/k8s.io/cri-api/pkg/` -- ディレクトリ構成
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` -- 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RuntimeServiceがproto3で定義されている | E-01 (18行目, 24行目) | ○ |
| C-02 | Pod Sandbox管理RPC群が定義されている | E-01 (28-50行目) | ○ |
| C-03 | コンテナ管理RPC群が定義されている | E-01 (52-80行目) | ○ |
| C-04 | Exec/Attach/PortForward RPCが定義されている | E-01 (82-89行目) | ○ |
| C-05 | Stats RPCが定義されている | E-01 (91-100行目) | ○ |
| C-06 | StopPodSandbox/RemovePodSandboxはべき等である | E-01 (32-45行目コメント) | ○ |
| C-07 | StopContainerにgrace periodがある | E-01 (56-61行目コメント) | ○ |
| C-08 | go_packageがk8s.io/cri-api/pkg/apis/runtime/v1 | E-01 (21行目) | ○ |
| C-09 | 機能一覧でNo.147がCRI API定義として定義 | E-03 (148行目) | ○ |
| C-10 | ImageServiceにListImages, PullImage等が定義されている | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- api.protoの後半部分（ImageService定義）は読み取り範囲外であるため、ImageService RPCの完全な一覧は推測に基づく
  - 候補：`staging/src/k8s.io/cri-api/pkg/apis/runtime/v1/api.proto` の後半部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- RuntimeServiceのRPC定義はソースコードから直接確認済み
- 1: 中リスク -- ImageServiceの詳細はprotoファイルの後半部分を確認する必要がある

## 6) レビュアーチェックリスト（最小）
- [ ] RuntimeServiceの全RPC定義がコードと一致しているか
- [ ] ImageServiceの全RPC定義を確認
- [ ] べき等性の記述がコメントと一致しているか
